/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_13; import lotus.domino.*; import djbuch.kapitel_06.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class CMSLoop implements Runnable {

	private static final String PASSWORD = "geheim";
	private static final String HOST = "www.djbuch.de"; 		//null fr lokale Session
	private static final String USER = "Thomas Ekert/DJBUCH";	//null fr lokale Session
	
	public static void main(String[] args) {
		CMSLoop cmsLoop = new CMSLoop ();
		NotesThread nt = new NotesThread ((Runnable) cmsLoop);
		nt.start();
	}
	
	public void run () {
		Session session = null;
		Database db = null;
		CMSDocument cmsDoc=null, nextDoc=null;
		View view=null;
		DocumentCollection dc=null;
		try {
			session=NotesFactory.createSession (HOST, USER, PASSWORD);
			db = session.getDatabase(session.getServerName(),"djbuch/djbuch.nsf");
			String key = "CMS Document " + System.currentTimeMillis();			
			cmsDoc = CMSDocument.getInstance (DemoTools.createDoc(db,"CMS",key,null));
			GC.recycle(cmsDoc);
			cmsDoc=null;
			view = db.getView("V_lookup_k6");
			dc=view.getAllDocumentsByKey("CMS Document ",false);
			cmsDoc=CMSDocument.getInstance (dc.getFirstDocument());
			while (cmsDoc!=null) {
				nextDoc = CMSDocument.getInstance (dc.getNextDocument(cmsDoc.getDoc()));
				cmsDoc.setActive(cmsDoc.isActive()?false:true);
				System.out.println (cmsDoc.getTitle() + " ist " + (cmsDoc.isActive()?"aktiv":"inaktiv"));
				cmsDoc.save(true,false);
				GC.recycle(cmsDoc);
				cmsDoc=nextDoc;
			}
		} catch (NotesException e) {
			System.out.println ("id = " + (e instanceof NotesException?""+((NotesException)e).id:""));
			e.printStackTrace();
		} finally {
			GC.recycle(cmsDoc);
			GC.recycle(nextDoc);
			GC.recycle(dc);
			GC.recycle(view);
			GC.recycle(db);
			GC.recycle(session);
		}		
	}
}
